<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml" 
                              xmlns:html="http://www.w3.org/1999/xhtml" 
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:wwmode="urn:WebWorks-Engine-Mode"
                              xmlns:wwdoc="urn:WebWorks-Document-Schema"
                              xmlns:wwsplits="urn:WebWorks-Engine-Splits-Schema"
                              xmlns:wwimaging="urn:WebWorks-XSLT-Extension-Imaging"
                              xmlns:wwlog="urn:WebWorks-XSLT-Extension-Log"
                              xmlns:wwuri="urn:WebWorks-XSLT-Extension-URI"
                              xmlns:wwfilesystem="urn:WebWorks-XSLT-Extension-FileSystem"
                              xmlns:wwprojext="urn:WebWorks-XSLT-Extension-Project"
                              exclude-result-prefixes="html xsl wwmode wwdoc wwsplits wwimaging wwlog wwuri wwprojext wwfilesystem"
>
  <xsl:import href="wwtransform:super" />
 
  <xsl:template match="wwdoc:Paragraph[@stylename = 'Equations w/number, catalog']" mode="wwmode:content">
    <xsl:param name="ParamParagraph" select="." />
    <xsl:param name="ParamSplits"/>
    <xsl:param name="ParamSplit"/>

    <html:table style="width: 100%;">
      <html:tr>
        <html:td style="padding-left: 5%; text-align: left;">
          <xsl:for-each select="$ParamParagraph/wwdoc:TextRun">
            <xsl:for-each select="wwdoc:Frame | wwdoc:Text">
              <xsl:variable name="VarItem" select="." />
              <xsl:choose>
                <xsl:when test="local-name() = 'Frame'">
                  <xsl:for-each select="$ParamSplits[1]">
                    <xsl:variable name="VarSplitsFrame" select="key('wwsplits-frames-by-id', $VarItem/@id)[@documentID = $ParamSplit/@documentID]" />
                    <xsl:variable name="VarImageInfo" select="wwimaging:GetInfo($VarSplitsFrame/@path)" />
     
                    <xsl:variable name="VarSrc" select="wwuri:GetRelativeTo($VarImageInfo/@path, $ParamSplit/@path)" />
                    <html:img src="{$VarSrc}" class="EquationGraphic" style="border: 0px; vertical-align: baseline;" />
                  </xsl:for-each>
                </xsl:when>

                <xsl:otherwise>
                  <html:span><xsl:value-of select="@value" /></html:span>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:for-each>
          </xsl:for-each>
        </html:td>  

        <!-- Second cell with fixed width -->
        <!--                                 -->
        <html:td style="padding-right: 20px; text-align: right;">
          <xsl:for-each select="$ParamParagraph/wwdoc:Number">
            <html:div style="font-weight: bold; font-size: large;">
              <xsl:for-each select="descendant::wwdoc:Text">
                <xsl:value-of select="@value" />
              </xsl:for-each>
            </html:div>
          </xsl:for-each>
        </html:td>
      </html:tr>
    </html:table>
  </xsl:template>
</xsl:stylesheet>
